package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author Loveven
 * @title: SetWeighingSendSpeedADPARequest
 * @projectName meter-jar
 * @description: 判稳跟零内码设定命令(组装请求)
 * @date 2021-06-1311:51
 */
public class CheckStableAndSetZeroCodeADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // Stable: 2个字节无符号
    private int stable;

    // Zero：2个字节无符号
    private int zero;

    public CheckStableAndSetZeroCodeADPARequest() {
        super(ADCMD.Check_Stable_And_Set_Zero_Code);
    }

    @Override
    public void assembly() throws MeterException {
        this.inner.append(ByteUtils.int2Hex((this.stable >> 8) & 0xff))
                .append(ByteUtils.int2Hex(this.stable & 0xff))
                .append(ByteUtils.int2Hex((this.stable >> 8) & 0xff))
                .append(ByteUtils.int2Hex(this.zero & 0xff));
    }

    public int getStable() {
        return stable;
    }

    public void setStable(int stable) {
        this.stable = stable;
    }

    public int getZero() {
        return zero;
    }

    public void setZero(int zero) {
        this.zero = zero;
    }
}
