package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.em.Flash;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author Loveven
 * @title: SetWeighingSendSpeedADPARequest
 * @projectName meter-jar
 * @description: Flash读命令(组装请求)
 * @date 2021-06-1311:51
 */
public class FlashReadADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // 当前序号 0~3  00 01 02 03  长度都是128
    private Flash flash;

    public FlashReadADPARequest() {
        super(ADCMD.Flash_Read);
    }

    @Override
    public void assembly() throws MeterException {
        this.inner.append(ByteUtils.ten2Hex(this.flash.getAddr(), 4))
                .append(ByteUtils.ten2Hex(this.flash.getLength() / 2, 2));
    }

    public Flash getFlash() {
        return flash;
    }

    public FlashReadADPARequest setFlash(Flash flash) {
        this.flash = flash;
        return this;
    }
}
