package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.em.Flash;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.protocol.ad.entity.inner.Flash_0;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author Loveven
 * @title: SetWeighingSendSpeedADPARequest
 * @projectName meter-jar
 * @description: Flash读命令(组装请求)
 * @date 2021-06-1311:51
 */
public class FlashWriteADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // 当前序号 0~3  00 01 02 03  长度都是128
    private Flash flash;

    private String part;

    public FlashWriteADPARequest() {
        super(ADCMD.Flash_Write);
    }

    /**
     * @description: 内容组装
     **/
    @Override
    public void assembly() throws MeterException {
        this.inner.append(ByteUtils.ten2Hex(this.flash.getAddr(), 4))
                .append(ByteUtils.ten2Hex(this.flash.getLength() / 2, 2))
                .append(this.part);
    }

    public FlashWriteADPARequest Flash_0(Flash_0 flash_0) {
        this.flash = Flash.Data_Unique;
        StringBuilder builder = new StringBuilder()
                .append(ByteUtils.convertTime(flash_0.getEvent()))
                .append(ByteUtils.ascii2Hex(flash_0.getSerial()));
        this.part = this.append(builder, Flash.Data_Unique.getLength());
        return this;
    }

    /**
     * @description: 填充内容
     **/
    private String append(StringBuilder builder, int length) {
        builder.append("00");
        int append = length - builder.length();
        int num = 1;
        for (int i = 0; i < append; i++) {
            if (num == 16) num = 1;
            builder.append(Integer.toHexString(num).toUpperCase());
            num++;
        }
        return builder.toString();
    }


    public Flash getFlash() {
        return flash;
    }

    public FlashWriteADPARequest setFlash(Flash flash) {
        this.flash = flash;
        return this;
    }

    public String getPart() {
        return part;
    }

    public FlashWriteADPARequest setPart(String part) {
        this.part = part;
        return this;
    }
}
