package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.em.TemplatureInExistState;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Loveven
 * @title: OpenCloseStrandardADPARequest
 * @projectName meter-jar
 * @description: 进入退出温度补偿状态(组装请求)
 * @date 2021-06-1312:02
 */
public class InExistTemperatureCompensationADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    //进出状态
    private TemplatureInExistState inExistState;

    // HEX字符命令
    private String inExistHex;

    public InExistTemperatureCompensationADPARequest() {
        super(ADCMD.In_Exist_Temperature_Compensation);
    }

    public InExistTemperatureCompensationADPARequest(TemplatureInExistState inExistState) {
        this();
        this.inExistState = inExistState;
    }

    public InExistTemperatureCompensationADPARequest(String inExistHex) {
        this();
        this.inExistHex = inExistHex;
    }

    @Override
    public void assembly() throws MeterException {
        if (this.inExistState == null && StringUtils.isBlank(this.inExistHex))
            throw new MeterException(MeterStateEnum.AD_温度补偿进出无效);
        this.inner.append(this.inExistState != null ? this.inExistState.getHex() : this.inExistHex);
    }

    public TemplatureInExistState getInExistState() {
        return inExistState;
    }

    public void setInExistState(TemplatureInExistState inExistState) {
        this.inExistState = inExistState;
    }

    public String getInExistHex() {
        return inExistHex;
    }

    public void setInExistHex(String inExistHex) {
        this.inExistHex = inExistHex;
    }
}
