package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.em.BackLight;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Loveven
 * @title: OpenCloseStrandardADPARequest
 * @projectName meter-jar
 * @description: 背光灯开关命令(组装请求)
 * @date 2021-06-1312:02
 */
public class OpenCloseBackLightADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // 背光灯开关命令
    private BackLight backLight;

    private String backLigntHex;

    public OpenCloseBackLightADPARequest() {
        super(ADCMD.Open_Close_Back_Light);
    }

    public OpenCloseBackLightADPARequest(BackLight backLight) {
        this();
        this.backLight = backLight;
    }

    public OpenCloseBackLightADPARequest(String backLigntHex) {
        this();
        this.backLigntHex = backLigntHex;
    }

    @Override
    public void assembly() throws MeterException {
        if (this.backLight == null && StringUtils.isBlank(this.backLigntHex))
            throw new MeterException(MeterStateEnum.AD_背光开关无效);
        this.inner.append(this.backLight != null ? this.backLight.getHex() : this.backLigntHex);
    }

    public BackLight getBackLight() {
        return backLight;
    }

    public void setBackLight(BackLight backLight) {
        this.backLight = backLight;
    }

    public String getBackLigntHex() {
        return backLigntHex;
    }

    public void setBackLigntHex(String backLigntHex) {
        this.backLigntHex = backLigntHex;
    }
}
