package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.em.Strandard;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Loveven
 * @title: OpenCloseStrandardADPARequest
 * @projectName meter-jar
 * @description: 进入、退出标定状态命令(组装请求)
 * @date 2021-06-1312:02
 */
public class OpenCloseStrandardADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // 标定状态
    private Strandard strandard;

    private String strandardHex;

    public OpenCloseStrandardADPARequest() {
        super(ADCMD.Open_Close_Standard);
    }

    public OpenCloseStrandardADPARequest(Strandard strandard) {
        this();
        this.strandard = strandard;
    }

    public OpenCloseStrandardADPARequest(String strandardHex) {
        this();
        this.strandardHex = strandardHex;
    }

    @Override
    public void assembly() throws MeterException {
        if (this.strandard == null && StringUtils.isBlank(this.strandardHex))
            throw new MeterException(MeterStateEnum.AD_进入退出标定无效);
        this.inner.append(this.strandard != null ? this.strandard.getHex() : this.strandardHex);
    }

    public Strandard getStrandard() {
        return strandard;
    }

    public void setStrandard(Strandard strandard) {
        this.strandard = strandard;
    }

    public String getStrandardHex() {
        return strandardHex;
    }

    public void setStrandardHex(String strandardHex) {
        this.strandardHex = strandardHex;
    }
}
