package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.em.TemplatureSwitchState;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Loveven
 * @title: OpenCloseStrandardADPARequest
 * @projectName meter-jar
 * @description: 温度补偿使能关闭、打开命令(组装请求)
 * @date 2021-06-1312:02
 */
public class OpenCloseTemperatureCompensationADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // 温度开关
    private TemplatureSwitchState switchState;

    private String switchStateHex;

    public OpenCloseTemperatureCompensationADPARequest() {
        super(ADCMD.Open_Close_Temperature_Compensation);
    }

    public OpenCloseTemperatureCompensationADPARequest(TemplatureSwitchState switchState) {
        this();
        this.switchState = switchState;
    }

    public OpenCloseTemperatureCompensationADPARequest(String switchStateHex) {
        this();
        this.switchStateHex = switchStateHex;
    }

    @Override
    public void assembly() throws MeterException {
        if (this.switchState == null && StringUtils.isBlank(this.switchStateHex))
            throw new MeterException(MeterStateEnum.AD_温度补偿开关无效);
        this.inner.append(this.switchState != null ? this.switchState.getHex() : this.switchStateHex);
    }

    public TemplatureSwitchState getSwitchState() {
        return switchState;
    }

    public void setSwitchState(TemplatureSwitchState switchState) {
        this.switchState = switchState;
    }

    public String getSwitchStateHex() {
        return switchStateHex;
    }

    public void setSwitchStateHex(String switchStateHex) {
        this.switchStateHex = switchStateHex;
    }
}
