package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.em.DigitalTube;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;

import java.math.BigDecimal;
import java.util.List;

/**
 * @author Loveven
 * @title: OpenCloseStrandardADPARequest
 * @projectName meter-jar
 * @description: 后显示设定命令(组装请求)
 * @date 2021-06-1312:02
 */
@Deprecated
public class SetBackDisplayADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    private List<BigDecimal> vals;

    private List<String> signs;

    public SetBackDisplayADPARequest() {
        super(ADCMD.Set_Back_Display);
    }

    public SetBackDisplayADPARequest(List<BigDecimal> vals) {
        this();
        this.vals = vals;
    }

    @Override
    public void assembly() throws MeterException {
        for (BigDecimal val : vals) {
            String varStr = val.toString();
            StringBuffer buffer = new StringBuffer();
            for (int i = varStr.length() - 1; i > -1; i--) {
                DigitalTube digitalTube = null;
                if (varStr.charAt(i) == '.') {
                    i--;
                    digitalTube = DigitalTube.digitalTube(varStr.charAt(i) + ".");
                } else if (i == varStr.length() - 1) {
                    digitalTube = DigitalTube.digitalTube(varStr.charAt(i) + ".");
                } else {
                    digitalTube = DigitalTube.digitalTube(String.valueOf(varStr.charAt(i)));
                }
                buffer.append(digitalTube.getHex());
            }

            int append = 12 - buffer.length();
            if (append < 0)
                throw new MeterException(MeterStateEnum.AD_背光板数值无效);

            for (int i = 0; i < append; i++) {
                buffer.append("0");
            }
            this.inner.append(buffer);
        }
        this.inner.append("FFFFFFFFFF");
    }

    public List<BigDecimal> getVals() {
        return vals;
    }

    public void setVals(List<BigDecimal> vals) {
        this.vals = vals;
    }

    public List<String> getSigns() {
        return signs;
    }

    public void setSigns(List<String> signs) {
        this.signs = signs;
    }

}
