package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author Loveven
 * @title: SetWeighingSendSpeedADPARequest
 * @projectName meter-jar
 * @description: 开机零点范围设定命令(组装请求)
 * @date 2021-06-1311:51
 */
public class SetBootZeroRangeADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // 开机范围
    private int range;

    public SetBootZeroRangeADPARequest() {
        super(ADCMD.Set_Boot_Zero_Range);
    }

    public SetBootZeroRangeADPARequest(int range) {
        this();
        this.range = range;
    }

    @Override
    public void assembly() throws MeterException {
        if (this.range < 0 || this.range > 100)
            throw new MeterException(MeterStateEnum.AD_开机零点范围无效);
        inner.append(ByteUtils.appendFill(Integer.toHexString(this.range), 2));
    }

    public int getRange() {
        return range;
    }

    public void setRange(int range) {
        this.range = range;
    }
}
