package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.em.Division;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: SetDivisionPARequest
 * @projectName meter-jar
 * @description: 分度值设定命令(组装请求)
 * @date 2021/6/1017:00
 */
public class SetDivisionADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // 分度值
    private Division division;

    private String divisionHex;

    public SetDivisionADPARequest() {
        super(ADCMD.Set_Division);
    }

    public SetDivisionADPARequest(Division division) {
        this();
        this.division = division;
    }

    public SetDivisionADPARequest(String divisionHex) {
        this();
        this.divisionHex = divisionHex;
    }

    @Override
    public void assembly() throws MeterException {
        if (this.division == null && StringUtils.isBlank(this.divisionHex))
            throw new MeterException(MeterStateEnum.AD_分度值无效);
        this.inner.append(this.division != null ? this.division.getHex() : this.divisionHex);
    }

    public Division getDivision() {
        return division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    public String getDivisionHex() {
        return divisionHex;
    }

    public void setDivisionHex(String divisionHex) {
        this.divisionHex = divisionHex;
    }
}
