package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author Loveven
 * @title: SetWeighingSendSpeedADPARequest
 * @projectName meter-jar
 * @description: 滤波强度设定命令(组装请求)
 * @date 2021-06-1311:51
 */
public class SetFilterStrengthADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // 滤波强度
    private int strength;

    public SetFilterStrengthADPARequest() {
        super(ADCMD.Set_Filter_Strength);
    }

    public SetFilterStrengthADPARequest(int strength) {
        this();
        this.strength = strength;
    }

    @Override
    public void assembly() throws MeterException {
        if (this.strength < 0 || this.strength > 3)
            throw new MeterException(MeterStateEnum.AD_滤波强度无效);
        inner.append(ByteUtils.appendFill(Integer.toHexString(this.strength), 2));
    }

    public int getStrength() {
        return strength;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }
}
