package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.em.Division;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author Loveven
 * @title: SetWeighingSendSpeedADPARequest
 * @projectName meter-jar
 * @description: 满量程设定命令(组装请求)
 * @date 2021-06-1311:51
 */
public class SetFullScaleADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // 满量程
    private int fullScale;

    // 双分度
    private int doubleDivision;

    // 小数点
    private int floa;

    // 分度值 0-10
    private Division division;

    private String divisionHex;

    public SetFullScaleADPARequest() {
        super(ADCMD.Set_Full_Scale);
    }

    public SetFullScaleADPARequest(int fullScale, int doubleDivision, int floa, Division division) {
        this();
        this.fullScale = fullScale;
        this.doubleDivision = doubleDivision;
        this.floa = floa;
        this.division = division;
    }

    public SetFullScaleADPARequest(int fullScale, int doubleDivision, int floa, String divisionHex) {
        this();
        this.fullScale = fullScale;
        this.doubleDivision = doubleDivision;
        this.floa = floa;
        this.divisionHex = divisionHex;
    }

    @Override
    public void assembly() throws MeterException {
        if (Objects.isNull(this.fullScale))
            throw new MeterException(MeterStateEnum.AD_满量程无效);

        // RangeDivision rangeDivision = RangeDivision.getRangeDivision(this.fullScale);
        // if (rangeDivision == null)
        //     throw new MeterException(MeterStateEnum.AD_满量程无效);

        String fullScaleHex = ByteUtils.appendFill(Integer.toHexString(this.fullScale), 6);
        this.inner.append(fullScaleHex);

        // if (rangeDivision.getSwitchRange() != this.doubleDivision)
        //     throw new MeterException(MeterStateEnum.AD_双分度切换点无效);
        String doubleDivisionHex = ByteUtils.appendFill(Integer.toHexString(this.doubleDivision), 6);
        this.inner.append(doubleDivisionHex);

        // if (this.floa > 3)
        //     throw new MeterException(MeterStateEnum.AD_满量程精度无效);
        String floaHex = ByteUtils.appendFill(Integer.toHexString(floa), 2);
        this.inner.append(floaHex);

        if (this.division == null && StringUtils.isBlank(this.divisionHex))
            throw new MeterException(MeterStateEnum.AD_分度值无效);
        this.inner.append(this.divisionHex != null ? this.divisionHex : this.division.getHex());
    }

    public int getFullScale() {
        return fullScale;
    }

    public void setFullScale(int fullScale) {
        this.fullScale = fullScale;
    }

    public int getDoubleDivision() {
        return doubleDivision;
    }

    public void setDoubleDivision(int doubleDivision) {
        this.doubleDivision = doubleDivision;
    }

    public int getFloa() {
        return floa;
    }

    public void setFloa(int floa) {
        this.floa = floa;
    }

    public Division getDivision() {
        return division;
    }

    public void setDivision(Division division) {
        this.division = division;
    }

    public String getDivisionHex() {
        return divisionHex;
    }

    public void setDivisionHex(String divisionHex) {
        this.divisionHex = divisionHex;
    }
}
