package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author lie_w
 * @title: SetPeeledPARequest
 * @projectName meter-jar
 * @description: 重力加速度系数设定命令(组装请求)
 * @date 2021/6/1016:13
 */
public class SetGACoefficientADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // 重力加速度
    private int gacofficient;

    public SetGACoefficientADPARequest() {
        super(ADCMD.Set_GA_Coefficient);
    }

    public SetGACoefficientADPARequest(int gacofficient) {
        this();
        this.gacofficient = gacofficient;
    }

    @Override
    public void assembly() throws MeterException {
        if (this.gacofficient < 95000 || this.gacofficient > 105000)
            throw new MeterException(MeterStateEnum.AD_重力加速度系数无效);
        this.inner.append(ByteUtils.appendFill(Integer.toHexString(this.gacofficient), 6));
    }

    public int getGacofficient() {
        return gacofficient;
    }

    public void setGacofficient(int gacofficient) {
        this.gacofficient = gacofficient;
    }
}
