package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.MeterUtils;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author lie_w
 * @title: SetPeeledPARequest
 * @projectName meter-jar
 * @description: 设皮命令(组装请求)
 * @date 2021/6/1016:13
 */
public class SetPeeledADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // 皮重
    private BigDecimal weight;

    public SetPeeledADPARequest() {
        super(ADCMD.Set_Peeled);
    }

    public SetPeeledADPARequest(BigDecimal weight) {
        this();
        this.weight = weight;
    }

    @Override
    public void assembly() throws MeterException {
        if (Objects.isNull(this.weight) && (this.weight.compareTo(new BigDecimal(0)) == -1 && this.weight.compareTo(new BigDecimal(16777215)) == 1))
            throw new MeterException(MeterStateEnum.AD_皮重无效);
        int floa = MeterUtils.checkIsDoublePointTwo(this.weight);
        int floatVal = MeterUtils.floatVal(floa);
        int val = this.weight.multiply(new BigDecimal(floatVal)).intValue();
        String valHex = ByteUtils.appendFill(Integer.toHexString(val), 6);
        String floaHex = ByteUtils.appendFill(Integer.toHexString(floa), 2);
        inner.append(valHex).append(floaHex);
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public void setWeight(BigDecimal weight) {
        this.weight = weight;
    }
}
