package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.em.WeighingMode;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: WeighingModelPA
 * @projectName meter-jar
 * @description: 设置模式(组装请求)
 * @date 2021/6/109:33
 */
public class SetWeighingModelADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    private WeighingMode weighingMode;

    private String weighingModeHex;

    public SetWeighingModelADPARequest() {
        super(ADCMD.Set_Weighing_Model);
    }

    public SetWeighingModelADPARequest(WeighingMode weighingMode) {
        this();
        this.weighingMode = weighingMode;
    }

    public SetWeighingModelADPARequest(String weighingModeHex) {
        this();
        this.weighingModeHex = weighingModeHex;
    }

    @Override
    public void assembly() throws MeterException {
        if (this.weighingMode == null && StringUtils.isBlank(this.weighingModeHex))
            throw new MeterException(MeterStateEnum.AD_发送模式无效);
        this.inner.append(this.weighingMode != null ? this.weighingMode.getVal() : this.weighingModeHex);
    }

    public WeighingMode getWeighingMode() {
        return weighingMode;
    }

    public void setWeighingMode(WeighingMode weighingMode) {
        this.weighingMode = weighingMode;
    }

    public String getWeighingModeHex() {
        return weighingModeHex;
    }

    public void setWeighingModeHex(String weighingModeHex) {
        this.weighingModeHex = weighingModeHex;
    }
}
