package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author Loveven
 * @title: SetWeighingSendSpeedADPARequest
 * @projectName meter-jar
 * @description: 重量发送速率设定命令(组装请求)
 * @date 2021-06-1311:51
 */
public class SetWeighingSendSpeedADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // 发送速率
    private int speed;

    public SetWeighingSendSpeedADPARequest() {
        super(ADCMD.Set_Weighing_Send_Speed);
    }

    public SetWeighingSendSpeedADPARequest(int speed) {
        this();
        this.speed = speed;
    }

    @Override
    public void assembly() throws MeterException {
        if (this.speed < 1 || this.speed > 30)
            throw new MeterException(MeterStateEnum.AD_发送速率无效);
        inner.append(ByteUtils.appendFill(Integer.toHexString(this.speed), 2));
    }

    public int getSpeed() {
        return speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }
}
