package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ad.em.ADCMD;
import com.jhscale.meter.protocol.ad.em.ZeroTrackRange;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * @author Loveven
 * @title: SetWeighingSendSpeedADPARequest
 * @projectName meter-jar
 * @description: 零点跟踪范围设定命令(组装请求)
 * @date 2021-06-1311:51
 */
public class SetZeroTrackRangeADPARequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // 零点跟踪范围
    private ZeroTrackRange range;

    private String rangeHex;

    public SetZeroTrackRangeADPARequest() {
        super(ADCMD.Set_Zero_Track_Range);
    }

    public SetZeroTrackRangeADPARequest(ZeroTrackRange range) {
        this();
        this.range = range;
    }

    public SetZeroTrackRangeADPARequest(String rangeHex) {
        this();
        this.rangeHex = rangeHex;
    }

    @Override
    public void assembly() throws MeterException {
        if (this.range == null && StringUtils.isBlank(this.rangeHex))
            throw new MeterException(MeterStateEnum.AD_发送速率无效);
        inner.append(this.range != null ? this.range.getHex() : this.rangeHex);
    }

    public ZeroTrackRange getRange() {
        return range;
    }

    public void setRange(ZeroTrackRange range) {
        this.range = range;
    }

    public String getRangeHex() {
        return rangeHex;
    }

    public void setRangeHex(String rangeHex) {
        this.rangeHex = rangeHex;
    }
}
