package com.jhscale.meter.protocol.ad.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.ad.em.ADProtocol;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyRequest;
import com.jhscale.meter.protocol.ad.entity.ADPackAssemblyResponse;
import com.jhscale.meter.utils.MeterConstant;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: SwitchProtocolRequest
 * @projectName meter-jar
 * @description: 改变秤重协议
 * @date 2021/10/1215:49
 */
public class SwitchProtocolRequest extends ADPackAssemblyRequest<ADPackAssemblyResponse> {

    // 协议命令
    private String protocol;

    // 协议枚举
    private ADProtocol ad;

    public SwitchProtocolRequest() {
    }

    public SwitchProtocolRequest(String protocol) {
        this.protocol = protocol;
    }

    public SwitchProtocolRequest(ADProtocol ad) {
        this.ad = ad;
    }

    @Override
    public ADPackAssemblyResponse execute() throws MeterException {
        StringBuffer buffer = new StringBuffer();
        if (StringUtils.isBlank(this.protocol) && Objects.isNull(this.ad)) {
            buffer.append(MeterConstant.SWITCH_PROTOCOL_TEMP_TOP);
            return new ADPackAssemblyResponse(buffer.toString());

        } else {
            buffer.append(MeterConstant.SWITCH_PROTOCOL_TOP);
            this.ad = StringUtils.isNotBlank(this.protocol) ? ADProtocol.protocol(this.protocol) : this.ad;
            if (Objects.nonNull(this.ad)) {
                buffer.append(this.ad.getProtocol());
            } else {
                for (int i = 0; i < 4; i++) {
                    buffer.append(this.protocol);
                }
            }
            return new ADPackAssemblyResponse(buffer.toString());
        }
    }

    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public ADProtocol getAd() {
        return ad;
    }

    public void setAd(ADProtocol ad) {
        this.ad = ad;
    }
}
