package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.ad.em.ADResult;
import com.jhscale.meter.protocol.ad.em.Flash;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author Loveven
 * @title: SetWeighingSendSpeedADPARequest
 * @projectName meter-jar
 * @description: Flash写命令(解析响应)
 * @date 2021-06-1311:51
 */
public class FlashWriteADPAResponse extends ADPackDisassemblyResponse {

    private Flash flash;

    /**
     * @return
     * @description: 内容解析
     */
    @Override
    public FlashWriteADPAResponse disassembly() throws MeterException {
        this.flash = Flash.addr(ByteUtils.hex2Ten(this.content.substring(0, 4)));
        int len = Integer.parseInt(this.content.substring(4), 16) * 2;
        this.result = this.flash != null && len == this.flash.getLength() ? ADResult.P : ADResult.E;
        this.resultHex = this.result.getSign();
        return this;
    }

    public Flash getFlash() {
        return flash;
    }

    public void setFlash(Flash flash) {
        this.flash = flash;
    }
}
