package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.em.BootState;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;

/**
 * @author lie_w
 * @title: WeighingModelPA
 * @projectName meter-jar
 * @description: 开机状态读取命令(解析响应)
 * @date 2021/6/109:33
 */
public class ObtainBootStateADPDResponse extends ADPackDisassemblyResponse {

    // 开机状态
    private BootState state;
    // 开机状态HEX
    private String stateHex;

    @Override
    public ObtainBootStateADPDResponse disassembly() throws MeterException {
        try {
            this.state = BootState.bootState(this.strVal());
            this.stateHex = this.content;
        } catch (Exception e) {
            JLog.error("ObtainBootStateADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_开机状态读取解析失败);
        }
        return this;
    }

    public BootState getState() {
        return state;
    }

    public String getStateHex() {
        return stateHex;
    }
}
