package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;

/**
 * @author lie_w
 * @title: WeighingModelPA
 * @projectName meter-jar
 * @description: 开机零点范围读取命令(解析响应)
 * @date 2021/6/109:33
 */
public class ObtainBootZeroRangeADPDResponse extends ADPackDisassemblyResponse {

    private Integer speed;

    @Override
    public ObtainBootZeroRangeADPDResponse disassembly() throws MeterException {
        try {
            this.speed = this.intVal();
        } catch (Exception e) {
            JLog.error("ObtainBootZeroRangeADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_开机零点范围读取解析失败);
        }
        return this;
    }

    public Integer getSpeed() {
        return speed;
    }
}
