package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.em.Division;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;

/**
 * @author lie_w
 * @title: ObtainWeigthADPDResponse
 * @projectName meter-jar
 * @description: 分度值读取命令(解析响应)
 * @date 2021/6/1113:45
 */
public class ObtainDivisionADPDResponse extends ADPackDisassemblyResponse {

    // 分度值
    private Division division;
    // 分度值HEX
    private String divisionHex;

    @Override
    public ObtainDivisionADPDResponse disassembly() throws MeterException {
        try {
            this.division = Division.division(this.intVal());
            this.divisionHex = this.content;
        } catch (Exception e) {
            JLog.error("ObtainDivisionADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_分度值读取解析失败);
        }
        return this;
    }

    public Division getDivision() {
        return division;
    }

    public String getDivisionHex() {
        return divisionHex;
    }
}
