package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;

/**
 * @author lie_w
 * @title: WeighingModelPA
 * @projectName meter-jar
 * @description: 滤波强度读取命令(解析响应)
 * @date 2021/6/109:33
 */
public class ObtainFilterStrengthADPDResponse extends ADPackDisassemblyResponse {

    private Integer strength;

    @Override
    public ObtainFilterStrengthADPDResponse disassembly() throws MeterException {
        try {
            this.strength = this.intVal();
        } catch (Exception e) {
            JLog.error("ObtainFilterStrengthADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_滤波强度读取解析失败);
        }
        return this;
    }

    public Integer getStrength() {
        return strength;
    }
}
