package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.em.Division;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;

/**
 * @author lie_w
 * @title: WeighingModelPA
 * @projectName meter-jar
 * @description: 满量程读取命令(解析响应)
 * @date 2021/6/109:33
 */
public class ObtainFullScaleADPDResponse extends ADPackDisassemblyResponse {

    // 满量程
    private int scale;

    // 小数点
    private int floa;

    // 分度值
    private Division division;

    // 分度值HEX
    private String divisionHex;

    @Override
    public ObtainFullScaleADPDResponse disassembly() throws MeterException {
        try {
            this.scale = Integer.parseInt(this.content.substring(0, 6), 16);
            this.floa = Integer.parseInt(this.content.substring(6, 8), 16);
            this.divisionHex = this.content.substring(8, 10);
            this.division = Division.division(Integer.parseInt(this.content.substring(8, 10), 16));
        } catch (Exception e) {
            JLog.error("ObtainFullScaleADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_满量程读取解析失败);
        }
        return this;
    }

    public int getScale() {
        return scale;
    }

    public int getFloa() {
        return floa;
    }

    public Division getDivision() {
        return division;
    }

    public String getDivisionHex() {
        return divisionHex;
    }
}
