package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;

/**
 * @author lie_w
 * @title: ObtainGACoefficientADPDResponse
 * @projectName meter-jar
 * @description: 重力加速度系数读取命令
 * @date 2021/7/1510:47
 */
public class ObtainGACoefficientADPDResponse extends ADPackDisassemblyResponse {

    // 重力加速度
    private int gacofficient;

    @Override
    public ObtainGACoefficientADPDResponse disassembly() throws MeterException {
        try {
            this.gacofficient = Integer.parseInt(this.content.substring(0, 6), 16);
        } catch (Exception e) {
            JLog.error("ObtainGACoefficientADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_读取重力加速度系数失败);
        }
        return this;
    }

    public int getGacofficient() {
        return gacofficient;
    }
}
