package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;
import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: WeighingModelPA
 * @projectName meter-jar
 * @description: 内码读取命令(解析响应)
 * @date 2021/6/109:33
 */
public class ObtainInternalCodeADPDResponse extends ADPackDisassemblyResponse {

    // 内码
    private Integer internalCode;
    // 内码标志
    private String sign;
    // 重量稳定
    private boolean s_stb = false;
    // 负值
    private boolean s_negative = false;

    @Override
    public ObtainInternalCodeADPDResponse disassembly() throws MeterException {
        try {
            this.internalCode = Integer.parseInt(content.substring(0, 6), 16);
            String sginStr = ByteUtils.formatMark(content.substring(6));
            if (StringUtils.isNotBlank(sginStr)) {
                StringBuffer buffer = new StringBuffer();
                if (sginStr.charAt(2) == '1') {
                    this.s_stb = true;
                    buffer.append("STB,");
                }

                if (sginStr.charAt(5) == '1') {
                    this.s_negative = true;
                    buffer.append("NEGATIVE,");
                }
                if (buffer.length() > 1) this.sign = buffer.substring(0, buffer.length() - 1);
            }
        } catch (Exception e) {
            JLog.error("ObtainInternalCodeADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_内码读取解析失败);
        }
        return this;
    }

    public Integer getInternalCode() {
        return internalCode;
    }

    public Integer getActualInternalCode() {
        return s_negative ? 0 - internalCode : internalCode;
    }

    public String getSign() {
        return sign;
    }

    public boolean isS_stb() {
        return s_stb;
    }

    public boolean isS_negative() {
        return s_negative;
    }
}
