package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;

/**
 * @author lie_w
 * @title: WeighingModelPA
 * @projectName meter-jar
 * @description: 当前温度读取命令(解析响应)
 * @date 2021/6/109:33
 */
public class ObtainTemperatureADPDResponse extends ADPackDisassemblyResponse {

    private Integer template;

    @Override
    public ObtainTemperatureADPDResponse disassembly() throws MeterException {
        try {
            this.template = this.intVal();
        } catch (Exception e) {
            JLog.error("ObtainTemperatureADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_读取当前温度解析失败);
        }
        return this;
    }

    public Integer getTemplate() {
        return template;
    }
}
