package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.em.TemplatureSwitchState;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;

/**
 * @author lie_w
 * @title: WeighingModelPA
 * @projectName meter-jar
 * @description: 温度补偿使能状态读取命令(解析响应)
 * @date 2021/6/109:33
 */
public class ObtainTemperatureCompensationADPDResponse extends ADPackDisassemblyResponse {

    // 温度补偿开关状态
    private TemplatureSwitchState switchState;

    // 状态
    private String switchStateHex;

    @Override
    public ObtainTemperatureCompensationADPDResponse disassembly() throws MeterException {
        try {
            this.switchStateHex = this.content;
            this.switchState = TemplatureSwitchState.switchState(this.intVal());
        } catch (Exception e) {
            JLog.error("ObtainTemperatureCompensationADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_读取温度补偿使能状态解析失败);
        }
        return this;
    }

    public TemplatureSwitchState getSwitchState() {
        return switchState;
    }

    public String getSwitchStateHex() {
        return switchStateHex;
    }
}
