package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;
import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: ObtainWeigthADPDResponse
 * @projectName meter-jar
 * @description: 版本号读取命令(解析响应)
 * @date 2021/6/1113:45
 */
public class ObtainVersionADPDResponse extends ADPackDisassemblyResponse {

    // 类型
    private String type;

    // 版本
    private String version;

    @Override
    public ADPackDisassemblyResponse disassembly() throws MeterException {
        try {
            this.type = content.substring(0, 2);
            String verstr = content.substring(2);
            if (StringUtils.isNotBlank(verstr)) {
                try {
                    this.version = "V" + ByteUtils.inserE(String.valueOf(Integer.parseInt(verstr, 16)), 2, ".");
                } catch (NumberFormatException e) {
                    this.version = new String(ByteUtils.fromHexString(verstr));
                }
            }
        } catch (Exception e) {
            JLog.error("ObtainVersionADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_版本号读取解析失败);
        }
        return this;
    }

    public String getType() {
        return type;
    }

    public String getVersion() {
        return version;
    }
}
