package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;

/**
 * @author lie_w
 * @title: WeighingModelPA
 * @projectName meter-jar
 * @description: 重量发送速率读取命令(解析响应)
 * @date 2021/6/109:33
 */
public class ObtainWeighingSendSpeedADPDResponse extends ADPackDisassemblyResponse {

    // 发送速率
    private int speed;

    @Override
    public ObtainWeighingSendSpeedADPDResponse disassembly() throws MeterException {
        try {
            this.speed = this.intVal();
        } catch (Exception e) {
            JLog.error("ObtainWeighingSendSpeedADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_重量发送速率读取解析失败);
        }
        return this;
    }

    public Integer getSpeed() {
        return speed;
    }
}
