package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;

/**
 * @author Loveven
 * @title: SetWeighingSendSpeedADPARequest
 * @projectName meter-jar
 * @description: 开机零位内码读取命令(解析响应)
 * @date 2021-06-1311:51
 */
public class ObtainZeroCodeOpenADPAResponse extends ADPackDisassemblyResponse {

    // 标志
    private int flag;

    // 零点内码
    private int zeroCode;

    @Override
    public ObtainZeroCodeOpenADPAResponse disassembly() throws MeterException {
        this.flag = Integer.parseInt(content.substring(0, 2), 16);
        int value = Integer.parseInt(this.content.substring(2, 8), 16);
        if (value >= 0x00800000) value -= 0x01000000;
        this.zeroCode = value;
        return this;
    }

    public int getFlag() {
        return flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public int getZeroCode() {
        return zeroCode;
    }

    public void setZeroCode(int zeroCode) {
        this.zeroCode = zeroCode;
    }
}
