package com.jhscale.meter.protocol.ad.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.ad.entity.ADPackDisassemblyResponse;

/**
 * @author lie_w
 * @title: ObtainWeigthADPDResponse
 * @projectName meter-jar
 * @description: 固件升级响应(解析响应) 响应成功后，等待1秒可开始刷入固件，超时未握手，自动重启
 * @date 2021/6/1113:45
 */
public class UpgradeFirmwareADPDResponse extends ADPackDisassemblyResponse {

    // 版本
    private String version;

    // 进度
    private String schedule;

    @Override
    public UpgradeFirmwareADPDResponse disassembly() throws MeterException {
        super.disassembly();
        try {
            Thread.sleep(1000);
        } catch (InterruptedException e) {
        }
        return this;
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSchedule() {
        return schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }
}
