package com.jhscale.meter.protocol.ad.listener;

import com.jhscale.common.utils.SystemtUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ad.em.CommunicationState;
import com.jhscale.meter.protocol.ad.entity.disassembly.UpgradeFirmwareADPDResponse;
import com.jhscale.meter.protocol.entity.ProtocolEntity;
import com.jhscale.meter.protocol.model.GlobalPara;
import com.jhscale.meter.utils.ByteUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * @author lie_w
 * @title: ADUpgradeEventListener
 * @projectName meter-jar
 * @description: AD 升级连接 监听器
 * @date 2021/6/188:29
 */
public class ADUpgradeEventListener extends ADScaleClientEventListener {

    // 发送升级数据长度
    private Integer size = 4;

    // 间隔休眠事件
    private Integer sleep = 12;

    // 握手指令状态
    private boolean shake_state = true;

    // 握手指令
    public static final byte[] shake = ByteUtils.fromHexString("55555555555555555555555555555555");

    // 升级流控
    private boolean upgrade = true;

    public ADUpgradeEventListener(IProtocolResponse protocolResponse, IProtocolManager protocolManager) {
        super(protocolResponse, protocolManager);
    }

    /**
     * @param bytes
     * @description: 连接监听
     */
    @Override
    public void onClientEvent(byte[] bytes) throws MeterException {
        if (GlobalPara.getInstance().isRunLog())
            System.out.println(String.format("Model: %s ; Content: %s", communication, ByteUtils.toHexString(bytes)));
        switch (communication) {
            case NORMAL:
                super.onClientEvent(bytes);
                if (shake_state)
                    this.manager.execute(shake);
                break;
            case SHAKE:
                // 握手
                super.addBuffer(bytes);
//                ADCache.getInstance().addBuffer(bytes);
                if (shake_state)
                    this.manager.execute(shake);
                break;
            case UPGRATE:
                // 升级
                String content = ByteUtils.toHexString(bytes);
                this.upgrade = StringUtils.isBlank(content) || !content.endsWith("13");
                super.clear();
//                ADCache.getInstance().clear();
                break;
        }
    }

    /**
     * @param buffer
     * @description: 执行解析发送
     */
    @Override
    public byte[] execute(byte[] buffer) {
        switch (communication) {
            case NORMAL:
                return super.execute(buffer);
            case SHAKE:
                // 握手
                int index = -1;
                for (int i = 0; i < buffer.length; i++) {
                    if (buffer[i] == 0X55) {
                        index = i;
                        break;
                    }
                }
                if (index == -1) return buffer;

                buffer = Arrays.copyOfRange(buffer, index, buffer.length);

                List<byte[]> bytes = new ArrayList<>();
                index = 0;
                for (int i = 0; i < buffer.length; i++) {
                    if (buffer[i] == 0X0D && i + 1 != buffer.length && buffer[i + 1] == 0X0A) {
                        bytes.add(Arrays.copyOfRange(buffer, index, i + 1));
                        index = i + 1;
                        continue;
                    }
                }

                try {
                    if (!bytes.isEmpty()) {
                        for (byte[] aByte : bytes) {
                            String version = new String(aByte).trim();
                            if (version.startsWith("U")) {
                                UpgradeFirmwareADPDResponse response = new UpgradeFirmwareADPDResponse();
                                response.setVersion(version);
                                if (this.defaultResponse != null && this.defaultResponse instanceof IProtocolResponse) {
                                    ((IProtocolResponse) this.defaultResponse).target(response);
                                }
                            }
                        }
                    }
                } catch (Exception e) {
                    if (defaultResponse != null)
                        defaultResponse.exp(new MeterException(e, MeterStateEnum.其他未知异常));
                }
                return Arrays.copyOfRange(buffer, index, buffer.length);
            case UPGRATE:
                break;
        }
        return new byte[0];
    }

    public void setShake_state(boolean shake_state) {
        this.shake_state = shake_state;
    }

    /**
     * @description: 文件升级（软流控升级）
     **/
    public void upgradeWithCtrl(byte[] bytes, PortManager portmanager) {
        // 升级
        // IProtocolResponse iProtocolResponse = (IProtocolResponse) responseMap.get(CommunicationState.UPGRATE.getKey());
        ProtocolEntity protocolEntity = responseMap.get(CommunicationState.UPGRATE.getKey());
        if (protocolEntity != null && protocolEntity.getResponse() != null) {
            // System.out.println("字节长度：" + bytes.length + " 长度： " + length);
            IProtocolResponse iProtocolResponse = (IProtocolResponse) protocolEntity.getResponse();
            try {
                int i = 0;
                while (i < bytes.length) {
                    if (this.upgrade) {
                        portmanager.writeDataImmediately(Arrays.copyOfRange(bytes, i, i + 1));
                        if (iProtocolResponse != null && (i % 512 == 0 || (i + 1) == bytes.length)) {
                            UpgradeFirmwareADPDResponse response = new UpgradeFirmwareADPDResponse();
                            response.setSchedule((i + 1) + "/" + bytes.length);
                            iProtocolResponse.target(response);

                            if (i + 1 == bytes.length) {
                                // 进度条截至，休眠20s 发送升级结束通知
                                int finalI = i;
                                GlobalPara.getInstance().executor().execute(() -> {
                                    SystemtUtils.sleep(20);
                                    UpgradeFirmwareADPDResponse upgradeFirmwareADPDFinishResponse = new UpgradeFirmwareADPDResponse();
                                    upgradeFirmwareADPDFinishResponse.setSchedule((finalI + 1) + "/" + bytes.length);
                                    iProtocolResponse.upgrade_finish(upgradeFirmwareADPDFinishResponse);
                                });
                            }
                        }
                        i++;
                        try {
                            Thread.sleep(2);
                        } catch (Exception e) {
                        }
                    } else {
                        if (GlobalPara.getInstance().isRunLog())
                            System.out.println("流控中");
                        try {
                            Thread.sleep(1);
                        } catch (Exception e) {
                        }
                    }
                }
                this.setCommunication(CommunicationState.NORMAL);
            } catch (MeterException e) {
                if (iProtocolResponse != null)
                    iProtocolResponse.exp(e);
            } catch (Exception e) {
                if (iProtocolResponse != null)
                    iProtocolResponse.exp(new MeterException(e, MeterStateEnum.其他未知异常));
            }
        }
    }

    /**
     * @description: 文件升级
     **/
    public void upgrade(byte[] bytes, PortManager portmanager) {
        // 升级
        int length = bytes.length % this.size == 0 ? bytes.length / this.size : bytes.length / this.size + 1;
//        IProtocolResponse iProtocolResponse = (IProtocolResponse) responseMap.get(CommunicationState.UPGRATE.getKey());
        ProtocolEntity protocolEntity = responseMap.get(CommunicationState.UPGRATE.getKey());
        if (protocolEntity != null && protocolEntity.getResponse() != null) {
            // System.out.println("字节长度：" + bytes.length + " 长度： " + length);
            IProtocolResponse iProtocolResponse = (IProtocolResponse) protocolEntity.getResponse();
            try {
                for (int i = 0; i < length; i++) {
                    int start = i * this.size;
                    int end = (i + 1) * this.size;
                    end = end > bytes.length ? bytes.length : end;

                    portmanager.writeDataImmediately(Arrays.copyOfRange(bytes, start, end));

                    if (iProtocolResponse != null && i % 256 == 0) {
                        UpgradeFirmwareADPDResponse response = new UpgradeFirmwareADPDResponse();
                        response.setSchedule((i + 1) + "/" + (length));
                        iProtocolResponse.target(response);
                    }

                    try {
                        Thread.sleep(this.sleep);
                    } catch (InterruptedException e) {
                    }
                }

                UpgradeFirmwareADPDResponse response = new UpgradeFirmwareADPDResponse();
                response.setSchedule(length + "/" + length);
                if (iProtocolResponse != null) iProtocolResponse.target(response);

                this.setCommunication(CommunicationState.NORMAL);

            } catch (MeterException e) {
                if (iProtocolResponse != null)
                    iProtocolResponse.exp(e);
            } catch (Exception e) {
                if (iProtocolResponse != null)
                    iProtocolResponse.exp(new MeterException(e, MeterStateEnum.其他未知异常));
            }
        }
    }
}
