package com.jhscale.meter.protocol.ad.send;

import com.jhscale.meter.log.JLog;
import com.jhscale.meter.utils.ByteUtils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author lie_w
 * @title: ADReadThread
 * @projectName meter-jar
 * @description: AD读异步线程
 * @date 2021/6/1916:25
 */
public class ADReadAsynThread extends Thread {

    // 缓冲区
    private List<byte[]> buffer = Collections.synchronizedList(new ArrayList<>());

    private ADAsynEvent asynEvent;

    // 启动状态
    private boolean start = false;

    // 暂停状态
    private boolean pause = false;

    /**
     * Allocates a new {@code Thread} object. This constructor has the same
     * effect as {@linkplain #(ThreadGroup, Runnable, String) Thread}
     * {@code (null, null, gname)}, where {@code gname} is a newly generated
     * name. Automatically generated names are of the form
     * {@code "Thread-"+}<i>n</i>, where <i>n</i> is an integer.
     */
    public ADReadAsynThread(ADAsynEvent asynEvent) {
        super("ADAsynEvent_Thread");
        this.asynEvent = asynEvent;
    }

    @Override
    public void run() {
        while (start && !this.isInterrupted()) {
            byte[] cache = new byte[0];
            while (pause) {
                while (this.buffer != null && !this.buffer.isEmpty()) {
                    byte[] next;
                    try {
                        next = this.buffer.remove(0);
//                System.out.println("缓冲获取：" + ByteUtils.toHexString(next) + "  当前缓冲：" + ByteUtils.toHexString(cache));
//                        System.out.println("缓冲获取：" + next.length + "  当前缓冲：" + cache.length);
                    } catch (Exception e) {
                        next = new byte[0];
                    }
                    try {
                        byte[] bytes = ByteUtils.byteMerger(cache, next);
//                    System.out.println("执行传递：" + ByteUtils.toHexString(bytes));
                        cache = asynEvent.execute(bytes);
//                    System.out.println("执行返回：" + ByteUtils.toHexString(cache));
                    } catch (Exception e) {
                        JLog.debug("执行 AD异步线程 异常：{}", e.getMessage(), e);
                        cache = next;
                    }
                }

                if (this.asynEvent != null)
                    this.asynEvent.expireCheck();

                try {
                    Thread.sleep(3);
                } catch (InterruptedException e) {
                }
            }

            try {
                Thread.sleep(3);
            } catch (InterruptedException e) {
            }
        }
    }

    /**
     * @description: 终止线程
     **/
    public synchronized void giveOver() {
        try {
            this.interrupt();
        } catch (Exception e) {
        } finally {
            this.start = false;
            this.pause = false;
            try {
                Thread.sleep(500);
            } catch (InterruptedException e) {
            }
        }
//        ADCache.getInstance().clear();
        this.clear();
    }

    /**
     * @description: 启动
     **/
    public synchronized void switchOn() {
        this.start = true;
        this.pause = !this.pause;
//        ADCache.getInstance().clear();
        this.clear();
    }

    /**
     * @description: 添加缓冲区
     **/
    public void addBuffer(byte[] bytes) {
        this.buffer.add(bytes);
    }

    /**
     * @description: 缓冲区清空
     **/
    public void clear() {
        this.buffer.clear();
    }
}
