package com.jhscale.meter.protocol.ble_print;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.io.PortManager;
import com.jhscale.meter.io.control.DeviceControl;
import com.jhscale.meter.model.device.Device;
import com.jhscale.meter.protocol.AbstractProtoManager;
import com.jhscale.meter.protocol.IBProtocolResponse;
import com.jhscale.meter.protocol.IProtocolManager;
import com.jhscale.meter.protocol.IProtocolResponse;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyRequest;
import com.jhscale.meter.protocol.ble_print.listener.BlePrintClientEventListener;
import com.jhscale.meter.protocol.entity.IPackRequest;
import com.jhscale.meter.protocol.entity.IPackResponse;

/**
 * @author lie_w
 * @title: BlePrintProtocolManager
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/5/2713:23
 */
public class BlePrintProtocolManager extends AbstractProtoManager<BPPackAssemblyRequest> {

    // 是否加密
    private boolean code = false;

    // 监听器
    private BlePrintClientEventListener listener;

    /**
     * @param portManager
     * @param protocolResponse
     * @description: 初始化通讯器（采用回调方式读取响应信息）
     * 通讯器实现类                           通讯器名称           安卓          WIN10
     * com.jhscale.meter.io.USBPort           USB通讯器            支持          缺少驱动
     * com.jhscale.meter.io.SerialPort        串口通讯器           支持          支持
     * com.jhscale.meter.io.BluetoothPort     蓝牙通讯器           支持          支持，需要支持蓝牙
     * com.jhscale.meter.io.NFCPort           NFC通讯器            不支持        不支持
     * com.jhscale.meter.io.EthernetPort      WIFI通讯器           不支持        不支持
     */
    @Override
    public IProtocolManager initPortmanager(PortManager portManager, IBProtocolResponse protocolResponse) {
        this.listener = new BlePrintClientEventListener(protocolResponse, this, this.code);
        return this.initPortmanager(portManager, this.listener);
    }

    /**
     * @param deviceControl
     * @param device
     * @param protocolResponse
     * @description: 初始化通讯器（采用回调方式读取响应信息）
     */
    @Override
    public IProtocolManager initPortmanager(DeviceControl deviceControl, Device device, IBProtocolResponse protocolResponse) throws MeterException {
        this.listener = new BlePrintClientEventListener(protocolResponse, this, this.code);
        return this.initPortmanager(new PortManager(deviceControl, device, this.listener));
    }

    /**
     * @param bytes
     * @description: 添加接受指令内容
     */
    @Override
    public void addClientEvent(byte[] bytes) {
        this.listener.addBuffer(bytes);
    }

    /**
     * @param request
     * @description: 命令处理（拼装|解析）
     */
    @Override
    public IPackResponse execute(IPackRequest request) throws MeterException {
        request.code(this.code);
        return request.execute();
    }

    /**
     * @param protocolResponse
     * @description: 固件升级握手
     */
    @Override
    public void shake(IProtocolResponse protocolResponse) throws MeterException {

    }

    /**
     * @param protocolResponse
     * @description: 直接握手
     */
    @Override
    public void shakeWithoutUpgradeFirmware(IProtocolResponse protocolResponse) throws MeterException {

    }

    /**
     * @param bytes
     * @param protocolResponse
     * @description: 固件升级
     */
    @Override
    public void upgrade(byte[] bytes, IProtocolResponse protocolResponse) throws MeterException {

    }

}
