package com.jhscale.meter.protocol.ble_print.em;

import com.jhscale.meter.protocol.ble_print.entity.assembly.*;
import com.jhscale.meter.protocol.ble_print.entity.disassembly.*;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: BPCMD
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/5/298:24
 */
public enum BPCMD {
    Set_Weighing_Model(1, "A", "41", "a", "61", "设置模式", SetWeighingModelBPPDResponse.class, SetWeighingModelBPPARequest.class),
    Obtain_MAC(2, "B", "42", "b", "62", "MAC读取命令（读取秤体蓝牙地址）", ObtainMacBPPDResponse.class, ObtainMacBPPARequest.class),
    Obtain_Weight(3, "C", "43", "c", "63", "重量信息", ObtainWeightBPPDResponse.class, ObtainWeightBPPARequest.class),
    Obtain_Weight_Master(4, "d", "44", "D", "64", "重量读取命令（读取当前重量，应答模式下需使用该命令，其他模式秤体主动发送）", ObtainWeightBPPDResponse.class, ObtainWeightBPPARequest.class),
    Set_Zero(5, "E", "45", "e", "65", "置零命令", SetZeroBPPDResponse.class, SetZeroBPPARequest.class),
    Set_Peeled_Zero(6, "F", "46", "f", "66", "去皮命令", SetPeeledZeroBPPDResponse.class, SetPeeledZeroBPPARequest.class),
    Obtain_Version(7, "G", "47", "g", "67", "版本号读取命令", ObtainVersionBPPDResponse.class, ObtainVersionBPPARequest.class),
    Power_Off(8, "H", "48", "h", "68", "关机命令", PowerOffBPPDResponse.class, PowerOffBPPARequest.class),
    Write_Text(9, "I", "49", "i", "69", "文本参数(写)", WriteTextBPPDResponse.class, WriteTextBPPARequest.class),
    Write_Print_Format(10, "J", "4A", "j", "6A", "打印格式(写)", WriteLabelFormatBPPDResponse.class, WriteLabelFormatBPPARequest.class),
    Write_PLU(11, "K", "4B", "k", "6B", "物品编号及名称(写)", WritePLUBPPDResponse.class, WritePLUBPPARequest.class),
    Write_Bar_Format(12, "L", "4C", "l", "6C", "条码格式(写)", WriteBarFormatBPPDResponse.class, WriteBarFormatBPPARequest.class),
    Read_Log(13, "M", "4D", "m", "6D", "日志记录(读)", ReadLOGBPPDResponse.class, ReadLOGBPPARequest.class),
    Set_Time(14, "N", "4E", "n", "6E", "设置时间", SetTimeBPPDResponse.class, SetTimeBPPARequest.class),
    Write_Data(15, "O", "4F", "o", "6F", "数据参数(写)", WriteDataBPPDResponse.class, WriteDataBPPARequest.class),
    Read_Response(16, "P", "50", "p", "70", "数据回收响应", ReadResponseBPPDResponse.class, ReadResponseBPPARequest.class),
    Command_Status(17, "Q", "51", "q", "71", "指令状态", CommandStatusBPPDResponse.class, CommandStatusBPPARequest.class),
    ;

    private Integer no;

    private String request_asscii;

    private String request_hex;

    private String response_asscii;

    private String response_hex;

    private String content;

    private Class clazz;

    private Class request;

    BPCMD(Integer no, String request_asscii, String request_hex, String response_asscii, String response_hex, String content, Class clazz, Class request) {
        this.no = no;
        this.request_asscii = request_asscii;
        this.request_hex = request_hex;
        this.response_asscii = response_asscii;
        this.response_hex = response_hex;
        this.content = content;
        this.clazz = clazz;
        this.request = request;
    }

    /**
     * @description: 获取相应对象信息
     **/
    public static Class get_clazz(String hex) {
        if (StringUtils.isBlank(hex)) return null;
        for (BPCMD bpcmd : BPCMD.values()) {
            if (hex.equalsIgnoreCase(bpcmd.getResponse_hex())) return bpcmd.clazz;
        }
        return null;
    }

    /**
     * @description: 获取命令信息
     **/
    public static BPCMD get_bpcmd(String hex) {
        if (StringUtils.isBlank(hex)) return null;
        for (BPCMD bpcmd : BPCMD.values()) {
            if (hex.equalsIgnoreCase(bpcmd.getResponse_hex())) return bpcmd;
        }
        return null;
    }

    /**
     * @description: 序号获取指令
     **/
    public static BPCMD no(Integer no) {
        if (Objects.isNull(no)) return null;
        for (BPCMD bpcmd : BPCMD.values()) {
            if (no.equals(bpcmd.getNo())) return bpcmd;
        }
        return null;
    }

    public Integer getNo() {
        return no;
    }

    public String getRequest_asscii() {
        return request_asscii;
    }

    public String getRequest_hex() {
        return request_hex;
    }

    public String getResponse_asscii() {
        return response_asscii;
    }

    public String getResponse_hex() {
        return response_hex;
    }

    public String getContent() {
        return content;
    }

    public Class getClazz() {
        return clazz;
    }

    public Class getRequest() {
        return request;
    }
}
