package com.jhscale.meter.protocol.ble_print.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.entity.PackAssemblyRequest;
import com.jhscale.meter.utils.CodeUtils;
import com.jhscale.meter.utils.Constant;

import java.util.Objects;

/**
 * @author lie_w
 * @title: ADPackAssembly
 * @projectName meter-jar
 * @description: (组装请求)
 * @date 2021/6/109:36
 */
public class BPPackAssemblyRequest<T extends BPPackAssemblyResponse> implements PackAssemblyRequest<BPPackAssemblyResponse> {

    // 命令
    private BPCMD bpcmd;

    // 内容体
    protected StringBuffer inner;

    // 是否code转义
    private boolean code = true;

    public BPPackAssemblyRequest() {
        this.inner = new StringBuffer();
    }

    public BPPackAssemblyRequest(BPCMD bpcmd) {
        this();
        this.bpcmd = bpcmd;
    }

    public BPCMD getBpcmd() {
        return bpcmd;
    }

    public void setBpcmd(BPCMD bpcmd) {
        this.bpcmd = bpcmd;
    }

    /**
     * @description: 协议执行器
     **/
    @Override
    public T execute() throws MeterException {
        if (Objects.isNull(this.bpcmd))
            throw new MeterException(MeterStateEnum.BP指令不存在);

        int frameNum = (int) (Math.random() * 255);
        String frame = Integer.toHexString(frameNum);
        if (frame.length() % 2 != 0) frame = "0" + frame;

        String cmd = this.bpcmd.getRequest_hex();
        int cmdNum = Integer.parseInt(cmd, 16);
        if (this.code) {
            cmdNum = cmdNum + CodeUtils.codeArr[(frameNum + 1) % 0x0100];
            if (cmdNum > 0xff) cmdNum -= 0x0100;
        }
        cmd = Integer.toHexString(cmdNum);
        if (cmd.length() % 2 != 0) cmd = "0" + cmd;

        int dataNum = 0, assembleDataLength = 0;// 内容值，组装数据长度

        // 内容体组装
        this.assembly();

        StringBuffer buffer = null;
        if (this.inner.length() > 0) {
            buffer = new StringBuffer();
            // 存在内容体
            if (this.inner.length() % 2 != 0)
                throw new MeterException(MeterStateEnum.BP数据格式错误);

            assembleDataLength = this.inner.length();
            for (int i = 0; i < (this.inner.length() / 2); i++) {
                String bit = this.inner.substring(i * 2, i * 2 + 2);
                int bitVal = Integer.parseInt(bit, 16);
                dataNum += bitVal;
                if (this.code) {
                    bitVal += CodeUtils.codeArr[(frameNum + 2 + i) % 0x0100];
                    if (bitVal > 0xff) bitVal -= 0x0100;
                }
                String bitData = Integer.toHexString(bitVal);
                buffer.append(bitData.length() % 2 != 0 ? "0" + bitData : bitData);
            }
        }

        String length = Integer.toHexString((cmd.length() + assembleDataLength) / 2);
        if (length.length() % 2 != 0) length = "0" + length;
        String verify = Integer.toHexString(frameNum + cmdNum + dataNum);
        verify = verify.substring(verify.length() - 2, verify.length());

        String cmdData = Constant.TOP + length + frame + cmd + (buffer != null ? buffer.toString() : "") + verify + Constant.END;
        if (this.code) cmdData = CodeUtils.encode(cmdData);
        return (T) new BPPackAssemblyResponse(this.bpcmd, frameNum, cmdData);
    }

    /**
     * @description: 是否加密
     **/
    @Override
    public boolean code() {
        return this.code;
    }

    /**
     * @param code
     * @description: 是否加密
     */
    @Override
    public void code(boolean code) {
        this.code = code;
    }

    /**
     * @description: 内容组装
     **/
    @Override
    public void assembly() throws MeterException {
    }

}
