package com.jhscale.meter.protocol.ble_print.entity;

import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.entity.PackAssemblyResponse;
import com.jhscale.meter.utils.ByteUtils;

/**
 * @author lie_w
 * @title: ADPackAssembly
 * @projectName meter-jar
 * @description: (组装响应)
 * @date 2021/6/109:36
 */
public class BPPackAssemblyResponse extends PackAssemblyResponse {

    // 发送CMD
    private String cmd;

    // CMD
    private BPCMD bpcmd;

    public BPPackAssemblyResponse() {
    }

    public BPPackAssemblyResponse(BPCMD bpcmd, int nid, String cmd) {
        super(nid);
        this.bpcmd = bpcmd;
        this.cmd = cmd;
    }

    public BPPackAssemblyResponse(String cmd) {
        this.cmd = cmd;
    }

    public String getCmd() {
        return cmd;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public BPCMD getBpcmd() {
        return bpcmd;
    }

    public void setBpcmd(BPCMD bpcmd) {
        this.bpcmd = bpcmd;
    }

    /**
     * @description: 操作指令
     **/
    @Override
    public int command() {
        return this.bpcmd.getNo();
    }

    /**
     * @description: HEX CMD
     **/
    public byte[] HEX() {
        return ByteUtils.fromHexString(this.cmd);
    }
}
