package com.jhscale.meter.protocol.ble_print.entity;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.entity.IPackResponse;
import com.jhscale.meter.protocol.entity.PackDisassemblyRequest;
import com.jhscale.meter.protocol.entity.ProtocolEntity;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.CodeUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.Map;

/**
 * @author lie_w
 * @title: ADPackDisassemblyRequest
 * @projectName meter-jar
 * @description: (解析请求)
 * @date 2021/6/1023:09
 */
public class BPPackDisassemblyRequest<T extends BPPackDisassemblyResponse> implements PackDisassemblyRequest<BPPackDisassemblyResponse> {

    // 是否加密
    private boolean code;

    // 缓冲区解码后字节流
    private byte[] bytes;

    // HEX字节源 串口收到的HEX数据
    private String cmd;

    // 命令字节
    private String hex;

    // 指令缓冲区
    private Map<String, ProtocolEntity> responseMap;

    public BPPackDisassemblyRequest() {
    }

    /**
     * @description: HEX码解析
     **/
    public BPPackDisassemblyRequest(String cmd) {
        this.cmd = cmd;
    }

    /**
     * @description: 解码后解析
     **/
    public BPPackDisassemblyRequest(Map<String, ProtocolEntity> responseMap, byte[] bytes) {
        this.responseMap = responseMap;
        this.bytes = bytes;
    }

    /**
     * @description: 协议执行器
     **/
    @Override
    public T execute() throws MeterException {
        if ((this.bytes == null || this.bytes.length == 0) && StringUtils.isBlank(cmd))
            throw new MeterException(MeterStateEnum.BP响应指令无效);

        String lengthStr, frameStr, cmdStr, dataStr, verifyStr;// 长度,帧号,命令/应答,数据内容,校验字段
        if (StringUtils.isNotBlank(this.cmd)) {
            // HEX字节源 串口收到的HEX数据 解析
            String source_cmd = this.cmd.trim().replace(" ", "");
            // if (this.code) source_cmd = CodeUtils.decode(this.cmd);
            String cmdData = CodeUtils.checkData(source_cmd);

            lengthStr = cmdData.substring(0, 2);// 长度
            frameStr = cmdData.substring(2, 4); // 帧号
            cmdStr = cmdData.substring(4, 6);// 命令/应答
            dataStr = cmdData.substring(6, cmdData.length() - 2);// 数据内容
            verifyStr = cmdData.substring(cmdData.length() - 2, cmdData.length());// 校验字段
            if (Integer.parseInt(lengthStr, 16) != (cmdStr.length() + dataStr.length()) / 2)
                throw new MeterException(MeterStateEnum.BP数据包长度检查错误);
        } else {
            byte[] source_bytes = this.bytes;
            // if (this.code) source_bytes = CodeUtils.decode(this.bytes);
            lengthStr = ByteUtils.toHexString(Arrays.copyOfRange(source_bytes, 1, 2));// 长度
            frameStr = ByteUtils.toHexString(Arrays.copyOfRange(source_bytes, 2, 3));// 帧号
            byte[] cmdb = Arrays.copyOfRange(source_bytes, 3, 4); // 命令/应答
            cmdStr = ByteUtils.toHexString(cmdb);// 命令/应答
            byte[] data = Arrays.copyOfRange(source_bytes, 4, source_bytes.length - 2);
            dataStr = ByteUtils.toHexString(data);// 数据内容
            verifyStr = ByteUtils.toHexString(Arrays.copyOfRange(source_bytes, source_bytes.length - 2, source_bytes.length - 1)); // 校验
            if (Integer.parseInt(lengthStr, 16) != data.length + cmdb.length) {
                throw new MeterException(MeterStateEnum.BP数据包长度检查错误);
            }
        }

        int frame = Integer.parseInt(frameStr, 16);

        int cmdVal = Integer.parseInt(cmdStr, 16);
        if (this.code) {
            cmdVal -= CodeUtils.codeArr[(frame + 1) % 0x0100];
            if (cmdVal < 0) cmdVal += 0x0100;
        }
        this.hex = Integer.toHexString(cmdVal);
        String cmd = ByteUtils.hex2Ascii(this.hex);

        int dataVal = 0;
        StringBuffer content = new StringBuffer();
        if (StringUtils.isNotBlank(dataStr)) {
            for (int i = 0; i < (dataStr.length() / 2); i++) {
                String bit = dataStr.substring(i * 2, i * 2 + 2);
                int bitVal = Integer.parseInt(bit, 16);
                if (this.code) {
                    bitVal -= CodeUtils.codeArr[(frame + 2 + i) % 0x0100];
                    if (bitVal < 0) bitVal += 0x0100;
                }
                dataVal += bitVal;
                String bitData = Integer.toHexString(bitVal);
                content.append(bitData.length() % 2 != 0 ? "0" + bitData : bitData);
            }
        }

        String cVerify = Integer.toHexString(frame + cmdVal + dataVal);
        cVerify = cVerify.substring(cVerify.length() - 2, cVerify.length());
        if (!cVerify.equalsIgnoreCase(verifyStr))
            throw new MeterException(MeterStateEnum.BP校验码无效);

        BPCMD bpcmd = BPCMD.get_bpcmd(this.hex);
        BPPackDisassemblyResponse response = (BPPackDisassemblyResponse) this.response();
        response.setNid(frame);
        response.setLength(Integer.parseInt(lengthStr, 16));
        response.setCmd(cmd);
        response.setBpcmd(bpcmd);
        response.setCommand(bpcmd.getNo());
        response.content = content.toString().trim();
        response.setRequest(this.request(response.KEY()));
        response.disassembly();
        return (T) response;
    }

    /**
     * @description: 获取请求对象信息
     **/
    public BPPackAssemblyRequest request(String frame) {
        if (this.responseMap != null) {
            ProtocolEntity protocolEntity = this.responseMap.get(frame);
            if (protocolEntity != null) {
                return (BPPackAssemblyRequest) protocolEntity.getRequest();
            }
        }
        return null;
    }

    /**
     * @description: 获取返回值类型
     **/
    @Override
    public <T extends IPackResponse> Class<T> getClazz() {
        return BPCMD.get_bpcmd(this.hex).getClazz();
    }

    /**
     * @description: 是否加密
     **/
    @Override
    public boolean code() {
        return this.code;
    }

    /**
     * @param code
     * @description: 是否加密
     */
    @Override
    public void code(boolean code) {
        this.code = code;
    }
}
