package com.jhscale.meter.protocol.ble_print.entity;

import com.jhscale.common.utils.ByteUtils;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ad.em.ADResult;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.entity.PackDisassemblyResponse;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author lie_w
 * @title: ADPackDisassemblyRequest
 * @projectName meter-jar
 * @description: (解析响应)
 * @date 2021/6/1023:09
 */
public class BPPackDisassemblyResponse<T extends BPPackAssemblyRequest> extends PackDisassemblyResponse {

    // 结果
    private ADResult result = ADResult.P;

    // 标识
    private String resultHex = ADResult.P.getSign();

    // 长度
    private int length;

    // 命令
    private String cmd;

    // 命令内容
    private BPCMD bpcmd;

    // 内容
    protected String content;

    // 结束标志
    protected boolean end = true;

    /**
     * @return
     * @description: 内容解析
     */
    @Override
    public BPPackDisassemblyResponse disassembly() throws MeterException {
        try {
            this.resultHex = new String(ByteUtils.fromHexString(this.split(2)));
            this.result = ADResult.result(this.resultHex);
        } catch (Exception e) {
            JLog.error("{} EXP:{}", this.getClass().getSimpleName(), e.getMessage(), e);
            throw new MeterException(MeterStateEnum.BP_操作结果解析失败);
        }
        return this;
    }

    public ADResult getResult() {
        return result;
    }

    public String getResultHex() {
        return resultHex;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int getLength() {
        return length;
    }

    public void setCmd(String cmd) {
        this.cmd = cmd;
    }

    public String getCmd() {
        return cmd;
    }

    public void setBpcmd(BPCMD bpcmd) {
        this.bpcmd = bpcmd;
    }

    public BPCMD getBpcmd() {
        return bpcmd;
    }

    // 请求对象信息
    private T request;

    protected void setRequest(T request) {
        this.request = request;
    }

    protected T getRequest() {
        return request;
    }

    /**
     * @description: 是否结束
     **/
    @Override
    public boolean end() {
        return this.end;
    }

    /**
     * @description: 长度截取
     **/
    protected String split(int length) {
        String part = this.content.substring(0, length);
        this.content = this.content.substring(length);
        return part;
    }

    /**
     * @description: 截取Int
     **/
    protected int split_int(int length) {
        return Integer.parseInt(this.split(length), 16);
    }

    /**
     * @description: 截取时间
     **/
    protected Date split_date() {
        return ByteUtils.convertTime_nr(this.split(8));
    }

    /**
     * @description: 截取金额
     **/
    protected BigDecimal split_bigDecimal() {
        return ByteUtils.convertBigDecimal(this.split(8));
    }

    /**
     * @description: 2进制字节状态
     **/
    protected String split_bin() {
        return ByteUtils.formatMark(this.split(2));
    }
}
