package com.jhscale.meter.protocol.ble_print.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ble_print.em.Action;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyRequest;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyResponse;
import org.apache.commons.lang3.StringUtils;

/**
 * @author lie_w
 * @title: WeighingModelPA
 * @projectName meter-jar
 * @description: 指令状态(组装请求)
 * @date 2021/6/109:33
 */
public class CommandStatusBPPARequest extends BPPackAssemblyRequest<BPPackAssemblyResponse> {

    private Action action;

    private String actionHex;

    public CommandStatusBPPARequest() {
        super(BPCMD.Command_Status);
    }

    public CommandStatusBPPARequest(Action action) {
        this();
        this.action = action;
    }

    public CommandStatusBPPARequest(String actionHex) {
        this();
        this.actionHex = actionHex;
    }

    @Override
    public void assembly() throws MeterException {
        if (this.action == null && StringUtils.isBlank(this.actionHex))
            throw new MeterException(MeterStateEnum.BP_指令状态无效);
        this.inner.append(this.action != null ? this.action.getHex() : this.actionHex);
    }

    public Action getAction() {
        return action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public String getActionHex() {
        return actionHex;
    }

    public void setActionHex(String actionHex) {
        this.actionHex = actionHex;
    }
}
