package com.jhscale.meter.protocol.ble_print.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyRequest;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyResponse;
import com.jhscale.meter.utils.MeterUtils;

/**
 * @author lie_w
 * @title: SetZeroRequest
 * @projectName meter-jar
 * @description: 日志信息（读）请求
 * @date 2021/6/1016:04
 */
public class ReadLOGBPPARequest extends BPPackAssemblyRequest<BPPackAssemblyResponse> {

    // 0x47--- Fid == 0 上传 全部数据 Fid != 0 Fid后的所有数据上传(不包括Fid)
    // 0X27--- Fid == 0 删除 全部数据 Fid != 0 Fid前的所有数据删除(不包括Fid)
    private String action;

    // FID后的所有数据再上传一次
    private int fid;

    public ReadLOGBPPARequest() {
        super(BPCMD.Read_Log);
    }

    /**
     * @description: 内容组装
     **/
    @Override
    public void assembly() throws MeterException {
        this.inner.append(this.action)
                .append(MeterUtils.append(this.fid, 4));
    }

    public String getAction() {
        return action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public Integer getFid() {
        return fid;
    }

    public void setFid(Integer fid) {
        this.fid = fid;
    }
}
