package com.jhscale.meter.protocol.ble_print.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyRequest;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyResponse;
import com.jhscale.meter.utils.MeterUtils;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author lie_w
 * @title: ReadResponseBPPARequest
 * @projectName meter-jar
 * @description: TODO
 * @date 2023/6/1610:01
 */
public class ReadResponseBPPARequest extends BPPackAssemblyRequest<BPPackAssemblyResponse> {

    // 回收数据内容命令
    private BPCMD data;

    // 回收数据内容命令字HEX
    private String data_hex;

    // 最后一条数据FID
    private Integer fid;

    // 数据状态 0 正常 其余不正常
    private Integer status;

    // 回收数据长度
    private Integer length;

    public ReadResponseBPPARequest() {
        super(BPCMD.Read_Response);
    }

    /**
     * @description: 内容组装
     **/
    @Override
    public void assembly() throws MeterException {
        this.inner.append(StringUtils.isNotBlank(this.data_hex) ? this.data_hex : this.data.getRequest_hex())
                .append(MeterUtils.append(this.fid, 4))
                .append(MeterUtils.append(Objects.nonNull(this.status) ? this.status : 0))
                .append(MeterUtils.append(Objects.nonNull(this.length) ? this.length : 10));
    }

    public BPCMD getData() {
        return data;
    }

    public void setData(BPCMD data) {
        this.data = data;
    }

    public String getData_hex() {
        return data_hex;
    }

    public void setData_hex(String data_hex) {
        this.data_hex = data_hex;
    }

    public Integer getFid() {
        return fid;
    }

    public void setFid(Integer fid) {
        this.fid = fid;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Integer getLength() {
        return length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }
}
