package com.jhscale.meter.protocol.ble_print.entity.assembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyRequest;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyResponse;
import com.jhscale.meter.utils.MeterUtils;

import java.util.Date;
import java.util.Objects;

/**
 * @author lie_w
 * @title: SetZeroRequest
 * @projectName meter-jar
 * @description: 设置时间(请求)
 * @date 2021/6/1016:04
 */
public class SetTimeBPPARequest extends BPPackAssemblyRequest<BPPackAssemblyResponse> {

    private Date date;

    public SetTimeBPPARequest() {
        super(BPCMD.Set_Time);
    }

    /**
     * @description: 内容组装
     **/
    @Override
    public void assembly() throws MeterException {
        this.inner.append(MeterUtils.append(Objects.nonNull(this.date) ? this.date : new Date()));
    }

    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
}
