package com.jhscale.meter.protocol.ble_print.entity.assembly;

import com.jhscale.common.model.device.barcode_format.DBarcodeFormatV2;
import com.jhscale.common.model.device.barcode_format.module.DBarV2;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyRequest;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyResponse;
import com.jhscale.meter.utils.MeterUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: SetZeroRequest
 * @projectName meter-jar
 * @description: 条码格式（写）请求
 * @date 2021/6/1016:04
 */
public class WriteBarFormatBPPARequest extends BPPackAssemblyRequest<BPPackAssemblyResponse> {

    private List<DBarcodeFormatV2> formats;

    public WriteBarFormatBPPARequest() {
        super(BPCMD.Write_Bar_Format);
    }

    /**
     * @description: 添加条码格式
     **/
    public void add(DBarcodeFormatV2... formats) {
        if (formats != null && formats.length > 0) {
            this.add(Arrays.asList(formats));
        }
    }

    /**
     * @description: 添加条码格式
     **/
    public void add(List<DBarcodeFormatV2> formats) {
        if (formats != null && !formats.isEmpty()) {
            if (this.formats == null) this.formats = new ArrayList<>();
            this.formats.addAll(formats);
        }
    }

    /**
     * @description: 内容组装
     **/
    @Override
    public void assembly() throws MeterException {
        if (Objects.isNull(this.formats))
            throw new MeterException(MeterStateEnum.BP条码格式不存在);

        int count = 0;
        for (DBarcodeFormatV2 format : this.formats) {
            if (format.getBars() != null && !format.getBars().isEmpty()) {
                count++;
            }
        }

        if (count != 0) {
            this.inner.append(MeterUtils.append(count));
            for (DBarcodeFormatV2 format : this.formats) {
                if (format.getBars() != null && !format.getBars().isEmpty()) {
                    this.inner.append(MeterUtils.append(format.no()))
                            .append(MeterUtils.append(Objects.nonNull(format.getSplit()) ? format.getSplit().substring(0, 1).getBytes() : new byte[]{0x00}))
                            .append(MeterUtils.append(format.getBars().size()));
                    for (Object o : format.getBars()) {
                        DBarV2 bar = (DBarV2) o;
                        this.inner.append(MeterUtils.append(bar.sno()))
                                .append(MeterUtils.append(bar.scontent()));
                    }
                }
            }
        }
    }

    public List<DBarcodeFormatV2> getFormats() {
        return formats;
    }

    public void setFormats(List<DBarcodeFormatV2> formats) {
        this.formats = formats;
    }
}
