package com.jhscale.meter.protocol.ble_print.entity.assembly;

import com.jhscale.common.model.device.data_parameter.DDataParameter;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyRequest;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyResponse;
import com.jhscale.meter.utils.MeterUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: SetZeroRequest
 * @projectName meter-jar
 * @description: 数据参数（写）请求
 * @date 2021/6/1016:04
 */
public class WriteDataBPPARequest extends BPPackAssemblyRequest<BPPackAssemblyResponse> {

    private List<DDataParameter> parameters;

    public WriteDataBPPARequest() {
        super(BPCMD.Write_Data);
    }

    /**
     * @description: 内容组装
     **/
    @Override
    public void assembly() throws MeterException {
        if (Objects.isNull(this.parameters) || this.parameters.isEmpty())
            throw new MeterException(MeterStateEnum.BP数据参数不存在);
        this.inner.append(MeterUtils.append(this.parameters.size()));
        for (DDataParameter parameter : parameters) {
            this.inner.append(MeterUtils.append(parameter.no()))
                    .append(MeterUtils.append(parameter.getValue()));
        }

    }

    /**
     * @description: 添加数据参数
     **/
    public void add(DDataParameter... parameters) {
        if (parameters != null && parameters.length > 0) {
            this.add(Arrays.asList(parameters));
        }
    }

    /**
     * @description: 添加数据参数
     **/
    public void add(List<DDataParameter> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            if (this.parameters == null) this.parameters = new ArrayList<>();
            this.parameters.addAll(parameters);
        }
    }

    public void setParameters(List<DDataParameter> parameters) {
        this.parameters = parameters;
    }
}
