package com.jhscale.meter.protocol.ble_print.entity.assembly;

import com.jhscale.common.model.device.label_format.DLabelFormatV2;
import com.jhscale.common.model.device.label_format.module.DLabelV2;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyRequest;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyResponse;
import com.jhscale.meter.utils.MeterUtils;

import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: SetZeroRequest
 * @projectName meter-jar
 * @description: 打印格式（写）请求
 * @date 2021/6/1016:04
 */
public class WriteLabelFormatBPPARequest extends BPPackAssemblyRequest<BPPackAssemblyResponse> {

    private DLabelFormatV2 format;

    public WriteLabelFormatBPPARequest() {
        super(BPCMD.Write_Print_Format);
    }

    /**
     * @description: 内容组装
     **/
    @Override
    public void assembly() throws MeterException {
        if (Objects.isNull(this.format))
            throw new MeterException(MeterStateEnum.BP打印格式不存在);

        this.inner.append(MeterUtils.append(this.format.no()))
                .append(MeterUtils.append(this.format.height()))
                .append(MeterUtils.append(this.format.weight()));

        List<DLabelV2> labels = this.format.getLabels();
        if (labels != null && !labels.isEmpty()) {
            this.inner.append(MeterUtils.append(labels.size()));
            for (DLabelV2 label : labels) {
                this.inner.append(MeterUtils.append(label.no()))
                        .append(MeterUtils.append(label.sign0()))
                        .append(MeterUtils.append(label.sign1()))
                        .append(MeterUtils.append(label.sign2()))
                        .append(MeterUtils.append(label.x(), 4))
                        .append(MeterUtils.append(label.y(), 4))
                        .append(MeterUtils.append(label.width(), 4))
                        .append(MeterUtils.append(label.height(), 4))
                        .append(MeterUtils.append(label._x(), 4))
                        .append(MeterUtils.append(label._y(), 4))
                        .append(MeterUtils.append(label.dir()))
                        .append(MeterUtils.append(label.format()))
                        .append(MeterUtils.append(label.grid()))
                        .append(MeterUtils.append(label.font()));
            }
        } else {
            throw new MeterException(MeterStateEnum.BP打印格式内容不存在);
        }
    }

    public DLabelFormatV2 getFormat() {
        return format;
    }

    public void setFormat(DLabelFormatV2 format) {
        this.format = format;
    }
}
