package com.jhscale.meter.protocol.ble_print.entity.assembly;

import com.jhscale.common.model.device.text_parameter.DTextParameter;
import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.protocol.ble_print.em.BPCMD;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyRequest;
import com.jhscale.meter.protocol.ble_print.entity.BPPackAssemblyResponse;
import com.jhscale.meter.utils.MeterUtils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

/**
 * @author lie_w
 * @title: SetZeroRequest
 * @projectName meter-jar
 * @description: 文本参数（写）请求
 * @date 2021/6/1016:04
 */
public class WriteTextBPPARequest extends BPPackAssemblyRequest<BPPackAssemblyResponse> {

    private List<DTextParameter> parameters;

    public WriteTextBPPARequest() {
        super(BPCMD.Write_Text);
    }

    /**
     * @description: 内容组装
     **/
    @Override
    public void assembly() throws MeterException {
        if (Objects.isNull(this.parameters) || this.parameters.isEmpty())
            throw new MeterException(MeterStateEnum.BP文本参数不存在);
        this.inner.append(MeterUtils.append(this.parameters.size()));
        for (DTextParameter parameter : parameters) {
            this.inner.append(MeterUtils.append(parameter.no()))
                    .append(MeterUtils.append(parameter.getValue()));
        }
    }

    /**
     * @description: 添加文本参数
     **/
    public void add(DTextParameter... parameters) {
        if (parameters != null && parameters.length > 0) {
            this.add(Arrays.asList(parameters));
        }
    }

    /**
     * @description: 添加文本参数
     **/
    public void add(List<DTextParameter> parameters) {
        if (parameters != null && !parameters.isEmpty()) {
            if (this.parameters == null) this.parameters = new ArrayList<>();
            this.parameters.addAll(parameters);
        }
    }

    public List<DTextParameter> getParameters() {
        return parameters;
    }

    public void setParameters(List<DTextParameter> parameters) {
        this.parameters = parameters;
    }
}
