package com.jhscale.meter.protocol.ble_print.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ble_print.entity.BPPackDisassemblyResponse;

/**
 * @author lie_w
 * @title: ObtainWeigthADPDResponse
 * @projectName meter-jar
 * @description: 读取Mac(解析响应)
 * @date 2021/6/1113:45
 */
public class ObtainMacBPPDResponse extends BPPackDisassemblyResponse {

    // 设备MAC
    private String mac;

    @Override
    public ObtainMacBPPDResponse disassembly() throws MeterException {
        try {
            this.mac = content.toUpperCase();
        } catch (Exception e) {
            JLog.error("ObtainMacADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_读取Mac解析失败);
        }
        return this;
    }

    public String getMac() {
        return mac;
    }
}
