package com.jhscale.meter.protocol.ble_print.entity.disassembly;

import com.jhscale.meter.exp.MeterException;
import com.jhscale.meter.exp.MeterStateEnum;
import com.jhscale.meter.log.JLog;
import com.jhscale.meter.protocol.ble_print.entity.BPPackDisassemblyResponse;
import com.jhscale.meter.utils.ByteUtils;
import com.jhscale.meter.utils.MeterUtils;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.Objects;

/**
 * @author lie_w
 * @title: ObtainWeigthADPDResponse
 * @projectName meter-jar
 * @description: 读取重量(解析响应)
 * @date 2021/6/1113:45
 */
public class ObtainWeightBPPDResponse extends BPPackDisassemblyResponse {

    // 标志
    private String flag;

    // 称重标志
    private String sign;

    // 当秤体硬件发生问题时
    private boolean s_adc = false;

    // 超重
    private boolean s_ovf = false;

    // 重量稳定
    private boolean s_stb = false;

    // 毛重为0
    private boolean s_zero = false;

    // 皮重不为0
    private boolean s_tare = false;

    // 负值
    private boolean s_negative = false;

    // 秤体特权模式（短路）
    private boolean s_privilege = false;

    // 开机超限
    private boolean s_on = false;

    // 浮动数值
    private Integer floa;

    // 重量数值
    private BigDecimal weight;

    // 皮重
    private BigDecimal tare;

    // 毛重
    private BigDecimal gross;

    // 带电池电量解析
    private BigDecimal power;

    @Override
    public ObtainWeightBPPDResponse disassembly() throws MeterException {
        try {
            this.flag();

            int floa, val = 0;
            Integer val2 = null;
            String val2Symbol = null;
            int length = content.length();
            if (length == 12) {
                // 带电池电压
                val = Integer.parseInt(content.substring(2, content.length() - 4), 16);
                floa = Integer.parseInt(content.substring(content.length() - 4, content.length() - 2), 16);
                this.power = new BigDecimal(Integer.parseInt(content.substring(content.length() - 2, content.length()), 16))
                        .divide(new BigDecimal(10));
            } else if (length == 18) {
                // 带皮重毛重
                val = Integer.parseInt(content.substring(2, 8), 16);
                floa = Integer.parseInt(content.substring(8, 10), 16);
                val2 = Integer.parseInt(content.substring(10, 16), 16);
                val2Symbol = ByteUtils.hex2Ascii(content.substring(16, 18));
            } else {
                // 正常
                val = Integer.parseInt(content.substring(2, content.length() - 2), 16);
                floa = Integer.parseInt(content.substring(content.length() - 2), 16);
            }

            this.floa = floa;// 浮动位数

            int floatVal = MeterUtils.floatVal(floa);

            this.weight = new BigDecimal(val).divide(new BigDecimal(floatVal));

            if (Objects.nonNull(val2)) {
                if ("T".equalsIgnoreCase(val2Symbol)) {
                    // 皮重
                    this.tare = new BigDecimal(val2).divide(new BigDecimal(floatVal));
                    this.gross = weight.add(this.tare);
                } else {
                    // 毛重
                    this.gross = new BigDecimal(val2).divide(new BigDecimal(floatVal));
                    this.tare = this.gross.subtract(this.weight);
                }
            }
        } catch (Exception e) {
            JLog.error("ObtainWeigthADPDResponse EXP:{}", e.getMessage(), e);
            throw new MeterException(MeterStateEnum.AD_读取重量解析失败);
        }
        return this;
    }

    /**
     * @description: 标志位解析
     **/
    private void flag() {
        this.flag = ByteUtils.formatMark(content.substring(0, 2));
        if (StringUtils.isNotBlank(this.flag)) {
            StringBuffer buffer = new StringBuffer();
            if (this.flag.charAt(0) == '1') {
                this.s_adc = true;
                buffer.append("ADC,");
            }

            if (this.flag.charAt(1) == '1') {
                this.s_ovf = true;
                buffer.append("OVF,");
            }

            if (this.flag.charAt(2) == '1') {
                this.s_stb = true;
                buffer.append("STB,");
            }

            if (this.flag.charAt(3) == '1') {
                this.s_zero = true;
                buffer.append("ZERO,");
            }

            if (this.flag.charAt(4) == '1') {
                this.s_tare = true;
                buffer.append("TARE,");
            }

            if (this.flag.charAt(5) == '1') {
                this.s_negative = true;
                buffer.append("NEGATIVE,");
            }

            if (this.flag.charAt(6) == '1') {
                this.s_privilege = true;
                buffer.append("PRIVILEGE,");
            }

            if (this.flag.charAt(7) == '1') {
                this.s_on = true;
                buffer.append("ON,");
            }

            if (buffer.length() > 1) this.sign = buffer.substring(0, buffer.length() - 1);
        }
    }

    public String getFlag() {
        return flag;
    }

    public String getSign() {
        return sign;
    }

    public boolean isS_adc() {
        return s_adc;
    }

    public boolean isS_ovf() {
        return s_ovf;
    }

    public boolean isS_stb() {
        return s_stb;
    }

    public boolean isS_zero() {
        return s_zero;
    }

    public boolean isS_tare() {
        return s_tare;
    }

    public boolean isS_negative() {
        return s_negative;
    }

    public boolean isS_privilege() {
        return s_privilege;
    }

    public boolean isS_on() {
        return s_on;
    }

    public Integer getFloa() {
        return floa;
    }

    public BigDecimal getWeight() {
        return weight;
    }

    public BigDecimal getActualWeight() {
        return s_negative && Objects.nonNull(weight) ? new BigDecimal(0).subtract(weight) : weight;
    }

    public BigDecimal getTare() {
        return tare;
    }

    public BigDecimal getGross() {
        return gross;
    }

    public BigDecimal getPower() {
        return power;
    }
}
